<?php
class ControllerModuleOcExchange1c20180929 extends Controller {
	private $error = array(); 

	public function index() {

		$language_all = $this->load->language('module/oc_exchange_1c_20180929');
		$this->load->model('tool/image');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('setting/setting');
		
		$data['oc_exchange_1c_version'] = '2018-09-29';
		$version = str_replace('-','', $data['oc_exchange_1c_version']);
		if (isset($_SERVER['SERVER_NAME']) AND $_SERVER['SERVER_NAME'] == 'localhost'){
			$data['LS'] = 'http://localhost'; 
		}else{
			$data['LS'] = 'http://license-server.info'; // URL официального сайта модуля и сервера лицензий
		}
		
		foreach ($language_all as $key => $value){
			if (strpos($key, 'oc_exchange_1c') === 0){
				$data[$key] = $value;
			}
		}
		
		$data['oc_exchange_1c_version_text'] = $this->language->get('oc_exchange_1c_version_version').$data['oc_exchange_1c_version'];
		
		$data['heading_title'] = $this->language->get('heading_title');
			
		$data['breadcrumbs'] = array();
		
		$data['breadcrumbs'][] = array(
			'text'		=> $this->language->get('text_home'),
			'href'		=> $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
			'separator'	=> false
		);

		$data['breadcrumbs'][] = array(
			'text'		=> $this->language->get('oc_exchange_1c_text_module'),
			'href'		=> $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'),
			'separator'	=> ' :: '
		);
		
		$data['breadcrumbs'][] = array(
			'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link("module/oc_exchange_1c_$version", 'token=' . $this->session->data['token'], 'SSL'),
			'separator' => ' :: '
		);


		$data['token'] = $this->session->data['token'];
		
		$data['button_save'] = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');

		$data['action'] = $this->url->link("module/oc_exchange_1c_$version", 'token=' . $this->session->data['token'], 'SSL');

		$data['cancel'] = $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL');
		
		$data['error_warning'] = '';
		$data['error'] = array();;
		
		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');
		
		// tab-general
		$data['oc_exchange_1c_status'] = 0;
		if ($this->user->hasPermission('modify', "module/oc_exchange_1c_$version")) {
			if (!is_null($this->config->get('oc_exchange_1c_status'))){
				$data['oc_exchange_1c_status'] = $this->config->get('oc_exchange_1c_status');
			}
			if (isset($this->request->post['oc_exchange_1c_status'])) {
				$data['oc_exchange_1c_status'] = $this->request->post['oc_exchange_1c_status'];
			}
		}
		
		if ($data['oc_exchange_1c_status'] == 0){
			$oc_exchange_1c_enabled = false;
		}else{
			$oc_exchange_1c_enabled = true;
		}
		
				
			if ($oc_exchange_1c_enabled){
				// проверка версии движка 
				if (!in_array(substr(VERSION, 0, 4), array('2.2.', '2.1.', '2.0.'))){
					$data['error_warning'] = str_replace('{VERSION}', VERSION, $this->language->get('oc_exchange_1c_wrong_version'));
					$oc_exchange_1c_enabled = false;
				}else{
					// проверка наличия модуля обмена
					if (!is_file("../$version/oc_exchange_1c.php")){
						$data['error_warning'] = $this->language->get('oc_exchange_1c_file_missing').' '.$version.'/oc_exchange_1c.php';
						$oc_exchange_1c_enabled = false;
					}else{
						// проверка лицензии
						$data['oc_exchange_1c_licese_msg'] = '';
						if ($_SERVER['SERVER_NAME'] == 'localhost'){
							$string = file_get_contents($data['LS']."/test-license.php?version=".$data['oc_exchange_1c_version']);
						}else{
							$string = $this->curl_get_contents($data['LS']."/test-license.php?version=".$data['oc_exchange_1c_version']);
						}
						if (isset($string[0]) AND $string[0] == '{'){
							$settings = json_decode($string, true);
							if (is_array($settings)){
								if (isset($settings['status'])){
									if ($settings['status'] == 'BAD'){
										$data['error_warning'] = str_replace('{LS}', $data['LS'], $this->language->get('oc_exchange_1c_LS_answer')).$settings['msg'];
										$oc_exchange_1c_enabled = false;
									}else if ($settings['status'] == 'OK'){
										$data['oc_exchange_1c_licese_msg'] = $settings['msg'];
									}else{
										$data['error_warning'] = str_replace('{LS}', $data['LS'], $this->language->get('oc_exchange_1c_LS_bad_answer')).$string;
										$oc_exchange_1c_enabled = false;
									}
								}else{
									$data['error_warning'] = str_replace('{LS}', $data['LS'], $this->language->get('oc_exchange_1c_LS_bad_answer')).$string;
									$oc_exchange_1c_enabled = false;
								}
							}else{
								$data['error_warning'] = str_replace('{LS}', $data['LS'], $this->language->get('oc_exchange_1c_LS_bad_answer')).$string;
								$oc_exchange_1c_enabled = false;
							}
						}else{
							$data['error_warning'] = str_replace('{LS}', $data['LS'], $this->language->get('oc_exchange_1c_LS_no_answer')).$string;
							$oc_exchange_1c_enabled = false;
						}
					}
				}
			}


		$data['oc_exchange_1c_enabled'] = $oc_exchange_1c_enabled;
		
		// tab-product
		// основные поля 
		$main_columns 		= array(	// имя поля в базе => 1-обязательно, имя поля в файле 
		'name' 				=> array(0, 'Наименование'),
		'model' 			=> array(0, 'Артикул'),
		'sku' 				=> array(0, 'Артикул'),
		'description' 		=> array(0, 'Описание'),
		'price' 			=> array(1, 'Цена'),
		'quantity' 			=> array(0, 'Количество'),
		'status' 			=> array(0, 'Статус'),
		);
		
		$keys				= array(	// поля, по которым можно идентифицировать товар
		'name',
		'model',
		);
		$data['keys'] = $keys;
		
		// характеристики
		$attributes_columns_r	= array(	// имя в базе => 1-обязательно, имя поля в файле

		);
		
		// значения по-умолчанию
		$default_values				= array(	// имя поля в базе => имя поля, по умолчанию, возможные значения - расчет далее
		'default_location'			=> array($this->language->get('oc_exchange_1c_text_location'), ''),
//		'default_quantity'			=> array($this->language->get('oc_exchange_1c_text_quantity'), 1000),
		'default_minimum'			=> array($this->language->get('oc_exchange_1c_text_mimimum'), 1),
//		'default_display' 			=> array($this->language->get('oc_exchange_1c_text_display'), 0),
		'default_subtract'			=> array($this->language->get('oc_exchange_1c_text_subtract'), 1),
		'default_stock_status_id'	=> array($this->language->get('oc_exchange_1c_text_stock_status_id'), 5),
		'default_shipping'			=> array($this->language->get('oc_exchange_1c_text_shipping'), 1),
		'default_length'			=> array($this->language->get('oc_exchange_1c_text_length'), 0),
		'default_width'				=> array($this->language->get('oc_exchange_1c_text_width'), 0),
		'default_height'			=> array($this->language->get('oc_exchange_1c_text_height'), 0),
		'default_length_class_id'	=> array($this->language->get('oc_exchange_1c_text_length_class_id'), 0),
		'default_weight'			=> array($this->language->get('oc_exchange_1c_text_weight'), 0),
		'default_weight_class_id'	=> array($this->language->get('oc_exchange_1c_text_weight_class_id'), 0),
		'default_sort_order'		=> array($this->language->get('oc_exchange_1c_text_sort_order'), 0),
//		'default_category'			=> array($this->language->get('oc_exchange_1c_text_new_category'), 1),
		'default_fill_parent_cats'	=> array($this->language->get('oc_exchange_1c_text_fill_parent_cats'), 1),
		);
		
		$spec_settings 						= array(	// специальные настройки	
		'hide_missing_products'				=> array($this->language->get('oc_exchange_1c_text_hide_missing_products'), 0),
		'hide_products_with_zero_quantity' 	=> array($this->language->get('oc_exchange_1c_text_hide_products_with_zero_quantity'), 0),
		'show_not_changed'					=> array($this->language->get('oc_exchange_1c_text_show_not_changed'), 0),

		);
		
		// TODO: опции 
//		$options_columns 	= array(	// имя в базе => 1-обязательно, имя поля в файле
//		'Размер' 			=> array(0, 'Размер', 'TheSize'),
//		'Цвет' 				=> array(0, 'Цвет', 'Color'),
//		);
		// ------------------
	
		// сохранение
		if (($this->request->server['REQUEST_METHOD'] == 'POST')) {
			
			if (count($this->request->post) > 1){
				
				if ($this->validate($version)){
					
					// пароль
					if ($this->request->post['oc_exchange_1c_login']){
						if ($this->request->post['oc_exchange_1c_pass'] != '') {
							$this->request->post['oc_exchange_1c_pass'] = md5($this->request->post['oc_exchange_1c_pass']);
						}else {
							if ($this->config->get('oc_exchange_1c_pass')){
								$this->request->post['oc_exchange_1c_pass'] = $this->config->get('oc_exchange_1c_pass');
							}
						}
					}else{
						$this->request->post['oc_exchange_1c_pass'] = '';
					}
					
					$this->request->post['oc_exchange_1c_timeout'] = (int)$this->request->post['oc_exchange_1c_timeout'];
					if ($this->request->post['oc_exchange_1c_timeout'] < 0){
						$this->request->post['oc_exchange_1c_timeout'] = 0;
					}
					if ($this->request->post['oc_exchange_1c_timeout'] > 2000){
						$this->request->post['oc_exchange_1c_timeout'] = 2000;
					}
					
					$this->request->post['oc_exchange_1c_timelimit'] = (int)$this->request->post['oc_exchange_1c_timelimit'];
					if ($this->request->post['oc_exchange_1c_timelimit'] < 20){
						$this->request->post['oc_exchange_1c_timelimit'] = 20;
					}
					
					// TODO: контроль атрибутов
					
					$this->model_setting_setting->editSetting('oc_exchange_1c', $this->request->post);
					$this->session->data['success'] = $this->language->get('text_success');
					$this->response->redirect($this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'));
				}
			}
			
			$data['error'] = $this->error;
			
		}
		
		if ($oc_exchange_1c_enabled){
			
				// settings
				
				// tab-general
				if (isset($this->request->post['oc_exchange_1c_login'])) {
					$data['oc_exchange_1c_login'] = $this->request->post['oc_exchange_1c_login'];
				}
				else {
					if ($this->config->get('oc_exchange_1c_login')){
						$data['oc_exchange_1c_login'] = $this->config->get('oc_exchange_1c_login');
					}else{
						$data['oc_exchange_1c_login'] = '';
					}
				}
				
				$data['oc_exchange_1c_pass'] = '';
				
				if (isset($this->request->post['oc_exchange_1c_IP'])) {
					$data['oc_exchange_1c_IP'] = $this->request->post['oc_exchange_1c_IP'];
				}
				else {
					if ($this->config->get('oc_exchange_1c_IP')){
						$data['oc_exchange_1c_IP'] = $this->config->get('oc_exchange_1c_IP');
					}else{
						$data['oc_exchange_1c_IP'] = '';
					}
				}
				
				$selected = 1;
				$oc_exchange_1c_log = array();
				if (isset($this->request->post['oc_exchange_1c_log'])) {
					$selected = $this->request->post['oc_exchange_1c_log'];
				}else {
					if (!is_null($this->config->get('oc_exchange_1c_log'))){
						$selected = $this->config->get('oc_exchange_1c_log');
					}
				}
				$values = array( array(1,$this->language->get('text_yes')), array(0,$this->language->get('text_no')));
				foreach ($values as $i => $value){
					$oc_exchange_1c_log[$i]['name'] = $value[1];
					$oc_exchange_1c_log[$i]['value'] = $value[0];
					$oc_exchange_1c_log[$i]['selected'] = 0;
					if ($value[0] == $selected){
						$oc_exchange_1c_log[$i]['selected'] = 1;
					}
				}
				$data['oc_exchange_1c_log'] = $oc_exchange_1c_log;
			
				if (isset($this->request->post['oc_exchange_1c_timeout'])) {
					$data['oc_exchange_1c_timeout'] = $this->request->post['oc_exchange_1c_timeout'];
				}
				else {
					if ($this->config->get('oc_exchange_1c_timeout')){
						$data['oc_exchange_1c_timeout'] = $this->config->get('oc_exchange_1c_timeout');
					}else{
						$data['oc_exchange_1c_timeout'] = '0';
					}
				}
				
				if (isset($this->request->post['oc_exchange_1c_timelimit'])) {
					$data['oc_exchange_1c_timelimit'] = $this->request->post['oc_exchange_1c_timelimit'];
				}
				else {
					if ($this->config->get('oc_exchange_1c_timelimit')){
						$data['oc_exchange_1c_timelimit'] = $this->config->get('oc_exchange_1c_timelimit');
					}else{
						$data['oc_exchange_1c_timelimit'] = '20';
					}
				}

				// tab-product
				
				// категории
				// синхронизировать категории 1С и сайта
				$selected = 1;
				$oc_exchange_1c_sinc_categories = array();
				if (isset($this->request->post['oc_exchange_1c_sinc_categories'])) {
					$selected = $this->request->post['oc_exchange_1c_sinc_categories'];
				}else {
					if (!is_null($this->config->get('oc_exchange_1c_sinc_categories'))){
						$selected = $this->config->get('oc_exchange_1c_sinc_categories');
					}
				}
				$values = array( array(1,$this->language->get('text_yes')), array(0,$this->language->get('text_no')));
				foreach ($values as $i => $value){
					$oc_exchange_1c_sinc_categories[$i]['name'] = $value[1];
					$oc_exchange_1c_sinc_categories[$i]['value'] = $value[0];
					$oc_exchange_1c_sinc_categories[$i]['selected'] = 0;
					if ($value[0] == $selected){
						$oc_exchange_1c_sinc_categories[$i]['selected'] = 1;
					}
				}
				$data['oc_exchange_1c_sinc_categories'] = $oc_exchange_1c_sinc_categories;
				
				// вывести категории сайта в отчет
				$selected = 0;
				$oc_exchange_1c_show_site_categories = array();
				if (isset($this->request->post['oc_exchange_1c_show_site_categories'])) {
					$selected = $this->request->post['oc_exchange_1c_show_site_categories'];
				}else {
					if (!is_null($this->config->get('oc_exchange_1c_show_site_categories'))){
						$selected = $this->config->get('oc_exchange_1c_show_site_categories');
					}
				}
				$values = array( array(1,$this->language->get('text_yes')), array(0,$this->language->get('text_no')));
				foreach ($values as $i => $value){
					$oc_exchange_1c_show_site_categories[$i]['name'] = $value[1];
					$oc_exchange_1c_show_site_categories[$i]['value'] = $value[0];
					$oc_exchange_1c_show_site_categories[$i]['selected'] = 0;
					if ($value[0] == $selected){
						$oc_exchange_1c_show_site_categories[$i]['selected'] = 1;
					}
				}
				$data['oc_exchange_1c_show_site_categories'] = $oc_exchange_1c_show_site_categories;
				
				// вывести категории 1С в отчет
				$selected = 0;
				$oc_exchange_1c_show_1c_categories = array();
				if (isset($this->request->post['oc_exchange_1c_show_1c_categories'])) {
					$selected = $this->request->post['oc_exchange_1c_show_1c_categories'];
				}else {
					if (!is_null($this->config->get('oc_exchange_1c_show_1c_categories'))){
						$selected = $this->config->get('oc_exchange_1c_show_1c_categories');
					}
				}
				$values = array( array(1,$this->language->get('text_yes')), array(0,$this->language->get('text_no')));
				foreach ($values as $i => $value){
					$oc_exchange_1c_show_1c_categories[$i]['name'] = $value[1];
					$oc_exchange_1c_show_1c_categories[$i]['value'] = $value[0];
					$oc_exchange_1c_show_1c_categories[$i]['selected'] = 0;
					if ($value[0] == $selected){
						$oc_exchange_1c_show_1c_categories[$i]['selected'] = 1;
					}
				}
				$data['oc_exchange_1c_show_1c_categories'] = $oc_exchange_1c_show_1c_categories;
				
				if (isset($this->request->post['oc_exchange_1c_categories_corr'])) {
					$data['oc_exchange_1c_categories_corr'] = $this->request->post['oc_exchange_1c_categories_corr'];
				}
				else {
					if ($this->config->get('oc_exchange_1c_categories_corr')){
						$data['oc_exchange_1c_categories_corr'] = $this->config->get('oc_exchange_1c_categories_corr');
					}else{
						$data['oc_exchange_1c_categories_corr'] = '';
					}
				}
				
				$selected = 0;
				if (isset($this->request->post['oc_exchange_1c_default_category'])) {
					$selected = $this->request->post['oc_exchange_1c_default_category'];
				}else {
					if (!is_null($this->config->get('oc_exchange_1c_default_category'))){
						$selected = $this->config->get('oc_exchange_1c_default_category');
					}
				}
				$values = $this->getCategoriesByParentId(0);
//echo '<pre>'; print_r ($values);	die;						
				foreach ($values as $i => $value){
					$default_value[$i]['name'] = $value['name'];
					$default_value[$i]['value'] = $value['category_id'];
					$default_value[$i]['selected'] = 0;
					if ($value['category_id'] == $selected){
						$default_value[$i]['selected'] = 1;
					}
				}
				
				$data['oc_exchange_1c_default_category'] = $default_value;
				
				// добавлять новые товары ?
				$selected = 1;
				$oc_exchange_1c_add_new_products = array();
				if (isset($this->request->post['oc_exchange_1c_add_new_products'])) {
					$selected = $this->request->post['oc_exchange_1c_add_new_products'];
				}else {
					if (!is_null($this->config->get('oc_exchange_1c_add_new_products'))){
						$selected = $this->config->get('oc_exchange_1c_add_new_products');
					}
				}
				$values = array( array(1,$this->language->get('text_yes')), array(0,$this->language->get('text_no')));
				foreach ($values as $i => $value){
					$oc_exchange_1c_add_new_products[$i]['name'] = $value[1];
					$oc_exchange_1c_add_new_products[$i]['value'] = $value[0];
					$oc_exchange_1c_add_new_products[$i]['selected'] = 0;
					if ($value[0] == $selected){
						$oc_exchange_1c_add_new_products[$i]['selected'] = 1;
					}
				}
				$data['oc_exchange_1c_add_new_products'] = $oc_exchange_1c_add_new_products;
				
				// добавлять новые товары с нулевым остатком
				$selected = 0;
				$oc_exchange_1c_add_new_products_zero = array();
				if (isset($this->request->post['oc_exchange_1c_add_new_products_zero'])) {
					$selected = $this->request->post['oc_exchange_1c_add_new_products_zero'];
				}else {
					if (!is_null($this->config->get('oc_exchange_1c_add_new_products_zero'))){
						$selected = $this->config->get('oc_exchange_1c_add_new_products_zero');
					}
				}
				$values = array( array(1,$this->language->get('text_yes')), array(0,$this->language->get('text_no')));
				foreach ($values as $i => $value){
					$oc_exchange_1c_add_new_products_zero[$i]['name'] = $value[1];
					$oc_exchange_1c_add_new_products_zero[$i]['value'] = $value[0];
					$oc_exchange_1c_add_new_products_zero[$i]['selected'] = 0;
					if ($value[0] == $selected){
						$oc_exchange_1c_add_new_products_zero[$i]['selected'] = 1;
					}
				}
				$data['oc_exchange_1c_add_new_products_zero'] = $oc_exchange_1c_add_new_products_zero;

				
				$update = array();
				// основные поля
				foreach ($main_columns as $pole => $param){
					$main = array();
					$main['star'] = $param[0]==1?'* ':'';
					$main['title'] = $this->language->get('oc_exchange_1c_text_'.$pole);
					$main['comment'] = '';
					$main['name'] = 'oc_exchange_1c_'.$pole;
					
					if ($pole == 'price'){
						if (isset($this->request->post['oc_exchange_1c_price'])) {
							$data['oc_exchange_1c_price'] = $this->request->post['oc_exchange_1c_price'];
						}
						else {
							if ($this->config->get('oc_exchange_1c_price')){
								$data['oc_exchange_1c_price'] = $this->config->get('oc_exchange_1c_price');
							}else{
								$data['oc_exchange_1c_price'] = '';
							}
						}
					}
					
					$main['checked'] = '';
					if (isset($this->request->post['oc_exchange_1c_update_'.$pole])) {
						$main['checked'] = $this->request->post['oc_exchange_1c_update_'.$pole]==1?'checked':'';
					}else {
						if ($this->config->get('oc_exchange_1c_update_'.$pole)){
							$main['checked'] = 'checked';
						}
					}
				
					$main['key_checked'] = '';
					if (isset($this->request->post['oc_exchange_1c_key']) AND $this->request->post['oc_exchange_1c_key'] == $pole) {
						$main['key_checked'] = $this->request->post['oc_exchange_1c_key']==$pole?'checked':'';
					}else {
						if ($this->config->get('oc_exchange_1c_key') == $pole){
							$main['key_checked'] = 'checked';
						}
					}
					
					$data['oc_exchange_1c_main'][$pole] = $main;
				}
				
				
				// Свойства
				
				$attributes_groups = array();
				
				$selected = 0;
				if (isset($this->request->post['oc_exchange_1c_attributes_group'])) {
					$selected = $this->request->post['oc_exchange_1c_attributes_group'];
				}else {
					if ($this->config->get('oc_exchange_1c_attributes_group')){
						$selected = $this->config->get('oc_exchange_1c_attributes_group');
					}
				}
					
				$this->load->model('catalog/attribute_group');
				$values = $this->model_catalog_attribute_group->getAttributeGroups();
//echo '<pre>'; print_r ($values);	die;
				foreach ($values as $i => $value){
					$attributes_groups[$i]['name'] = $value['name'];
					$attributes_groups[$i]['value'] = $value['attribute_group_id'];
					$attributes_groups[$i]['selected'] = 0;
					if ($value['attribute_group_id'] == $selected){
						$attributes_groups[$i]['selected'] = 1;
					}
				}
				$first_option['name'] = $this->language->get('oc_exchange_1c_text_select_attributes_group');
				$first_option['value'] = 0;
				$first_option['selected'] = 0;
				array_unshift($attributes_groups, $first_option);
				$data['attributes_groups'] = $attributes_groups;
				
				if (isset($this->request->post['oc_exchange_1c_attributes'])) {
					$data['oc_exchange_1c_attributes'] = $this->request->post['oc_exchange_1c_attributes'];
				}
				else {
					if ($this->config->get('oc_exchange_1c_attributes')){
						$data['oc_exchange_1c_attributes'] = $this->config->get('oc_exchange_1c_attributes');
					}else{
						$data['oc_exchange_1c_attributes'] = '';
					}
				}
				if (isset($this->request->post['oc_exchange_1c_update_attributes'])) {
					$data['oc_exchange_1c_update_attributes'] = $this->request->post['oc_exchange_1c_update_attributes']==1?'checked':'';
				}
				else {
					if ($this->config->get('oc_exchange_1c_update_attributes')){
						$data['oc_exchange_1c_update_attributes'] = $this->config->get('oc_exchange_1c_update_attributes')==1?'checked':'';
					}else{
						$data['oc_exchange_1c_update_attributes'] = '';
					}
				}
				
				// Опции - Связанные опции
				
				$options_variant = array();
				
				$selected = 0;
				if (isset($this->request->post['oc_exchange_1c_options_variant'])) {
					$selected = $this->request->post['oc_exchange_1c_options_variant'];
				}else {
					if ($this->config->get('oc_exchange_1c_options_variant')){
						$selected = $this->config->get('oc_exchange_1c_options_variant');
					}
				}
				
				// проверка связанных опций
				$model = 'module/related_options';
				$model = str_replace('../', '', (string)$model);
				$file = DIR_APPLICATION . 'model/' . $model . '.php';
				if (is_file($file)){
					$this->load->model('module/related_options');
					$values = $this->model_module_related_options->get_variants_options();
//echo '<pre>'; print_r ($values);	die;
					foreach ($values as $i => $value){
						$options_variant[$i]['name'] = $value['name'];
						$options_variant[$i]['value'] = $i;
						$options_variant[$i]['selected'] = 0;
						if ($i == $selected){
							$options_variant[$i]['selected'] = 1;
						}
					}
				}
				$first_option['name'] = $this->language->get('oc_exchange_1c_text_select_options_variant');
				$first_option['value'] = 0;
				$first_option['selected'] = 0;
				array_unshift($options_variant, $first_option);
				$data['options_variant'] = $options_variant;
				
				if (isset($this->request->post['oc_exchange_1c_options'])) {
					$data['oc_exchange_1c_options'] = $this->request->post['oc_exchange_1c_options'];
				}
				else {
					if ($this->config->get('oc_exchange_1c_options')){
						$data['oc_exchange_1c_options'] = $this->config->get('oc_exchange_1c_options');
					}else{
						$data['oc_exchange_1c_options'] = '';
					}
				}
				if (isset($this->request->post['oc_exchange_1c_update_options'])) {
					$data['oc_exchange_1c_update_options'] = $this->request->post['oc_exchange_1c_update_options']==1?'checked':'';
				}
				else {
					if ($this->config->get('oc_exchange_1c_update_options')){
						$data['oc_exchange_1c_update_options'] = $this->config->get('oc_exchange_1c_update_options')==1?'checked':'';
					}else{
						$data['oc_exchange_1c_update_options'] = '';
					}
				}

				// значения по-умолчанию
				foreach ($default_values as $pole => $param){
					$default_value = array();
					$default_value['title'] = $param[0];
					$default_value['name'] = 'oc_exchange_1c_'.$pole;
					
					$selected = $param[1];
					if (isset($this->request->post['oc_exchange_1c_'.$pole])) {
						$selected = $this->request->post['oc_exchange_1c_'.$pole];
					}else {
						if (!is_null($this->config->get('oc_exchange_1c_'.$pole))){
							$selected = $this->config->get('oc_exchange_1c_'.$pole);
						}
					}
					
					switch ($pole){
					
						case 'default_display':
							$values = array( array(0,$this->language->get('text_disabled')), array(1,$this->language->get('text_enabled')));
							foreach ($values as $i => $value){
								$default_value['option'][$i]['name'] = $value[1];
								$default_value['option'][$i]['value'] = $value[0];
								$default_value['option'][$i]['selected'] = 0;
								if ($value[0] == $selected){
									$default_value['option'][$i]['selected'] = 1;
								}
							}
							break;
							
						case 'default_subtract':
						case 'default_shipping':
						case 'default_fill_parent_cats':
							$values = array( array(0,$this->language->get('text_no')), array(1,$this->language->get('text_yes')));
							foreach ($values as $i => $value){
								$default_value['option'][$i]['name'] = $value[1];
								$default_value['option'][$i]['value'] = $value[0];
								$default_value['option'][$i]['selected'] = 0;
								if ($value[0] == $selected){
									$default_value['option'][$i]['selected'] = 1;
								}
							}
							break;
							
						case 'default_stock_status_id':
							$this->load->model('localisation/stock_status');
							$values = $this->model_localisation_stock_status->getStockStatuses();
//echo '<pre>'; print_r ($values);	die;
							foreach ($values as $i => $value){
								$default_value['option'][$i]['name'] = $value['name'];
								$default_value['option'][$i]['value'] = $value['stock_status_id'];
								$default_value['option'][$i]['selected'] = 0;
								if ($value['stock_status_id'] == $selected){
									$default_value['option'][$i]['selected'] = 1;
								}
							}
							break;
							
						case 'default_length_class_id':
							$this->load->model('localisation/length_class');
							$values = $this->model_localisation_length_class->getLengthClasses();
//echo '<pre>'; print_r ($values);	die;						
							foreach ($values as $i => $value){
								$default_value['option'][$i]['name'] = $value['title'];
								$default_value['option'][$i]['value'] = $value['length_class_id'];
								$default_value['option'][$i]['selected'] = 0;
								if ($value['length_class_id'] == $selected){
									$default_value['option'][$i]['selected'] = 1;
								}
							}
							break;
							
						case 'default_weight_class_id':
							$this->load->model('localisation/weight_class');
							$values = $this->model_localisation_weight_class->getWeightClasses();
//echo '<pre>'; print_r ($values);	die;						
							foreach ($values as $i => $value){
								$default_value['option'][$i]['name'] = $value['title'];
								$default_value['option'][$i]['value'] = $value['weight_class_id'];
								$default_value['option'][$i]['selected'] = 0;
								if ($value['weight_class_id'] == $selected){
									$default_value['option'][$i]['selected'] = 1;
								}
							}
							break;
							
						default:
							$default_value['value'] = $selected;
							break;
						
					}
					
					$data['oc_exchange_1c_default_values'][$pole] = $default_value;
				}
				
				// мета-теги
				// category
				if (isset($this->request->post['oc_exchange_1c_meta_title_category'])) {
					$data['oc_exchange_1c_meta_title_category'] = $this->request->post['oc_exchange_1c_meta_title_category'];
				}
				else {
					if ($this->config->get('oc_exchange_1c_meta_title_category')){
						$data['oc_exchange_1c_meta_title_category'] = $this->config->get('oc_exchange_1c_meta_title_category');
					}else{
						$data['oc_exchange_1c_meta_title_category'] = '{category-name}';
					}
				}
				
				if (isset($this->request->post['oc_exchange_1c_meta_h1_category'])) {
					$data['oc_exchange_1c_meta_h1_category'] = $this->request->post['oc_exchange_1c_meta_h1_category'];
				}
				else {
					if ($this->config->get('oc_exchange_1c_meta_h1_category')){
						$data['oc_exchange_1c_meta_h1_category'] = $this->config->get('oc_exchange_1c_meta_h1_category');
					}else{
						$data['oc_exchange_1c_meta_h1_category'] = '{category-name}';
					}
				}
				
				if (isset($this->request->post['oc_exchange_1c_meta_description_category'])) {
					$data['oc_exchange_1c_meta_description_category'] = $this->request->post['oc_exchange_1c_meta_description_category'];
				}
				else {
					if ($this->config->get('oc_exchange_1c_meta_description_category')){
						$data['oc_exchange_1c_meta_description_category'] = $this->config->get('oc_exchange_1c_meta_description_category');
					}else{
						$data['oc_exchange_1c_meta_description_category'] = '{category-name}';
					}
				}

				if (isset($this->request->post['oc_exchange_1c_meta_keywords_category'])) {
					$data['oc_exchange_1c_meta_keywords_category'] = $this->request->post['oc_exchange_1c_meta_keywords_category'];
				}
				else {
					if ($this->config->get('oc_exchange_1c_meta_keywords_category')){
						$data['oc_exchange_1c_meta_keywords_category'] = $this->config->get('oc_exchange_1c_meta_keywords_category');
					}else{
						$data['oc_exchange_1c_meta_keywords_category'] = '{category-name}';
					}
				}
				// product
				if (isset($this->request->post['oc_exchange_1c_meta_title'])) {
					$data['oc_exchange_1c_meta_title'] = $this->request->post['oc_exchange_1c_meta_title'];
				}
				else {
					if ($this->config->get('oc_exchange_1c_meta_title')){
						$data['oc_exchange_1c_meta_title'] = $this->config->get('oc_exchange_1c_meta_title');
					}else{
						$data['oc_exchange_1c_meta_title'] = '{name}';
					}
				}
				if (isset($this->request->post['oc_exchange_1c_update_meta_title'])) {
					$data['oc_exchange_1c_update_meta_title'] = $this->request->post['oc_exchange_1c_update_meta_title']==1?'checked':'';
				}
				else {
					if ($this->config->get('oc_exchange_1c_update_meta_title')){
						$data['oc_exchange_1c_update_meta_title'] = $this->config->get('oc_exchange_1c_update_meta_title')==1?'checked':'';
					}else{
						$data['oc_exchange_1c_update_meta_title'] = '';
					}
				}
				
				if (isset($this->request->post['oc_exchange_1c_meta_h1'])) {
					$data['oc_exchange_1c_meta_h1'] = $this->request->post['oc_exchange_1c_meta_h1'];
				}
				else {
					if ($this->config->get('oc_exchange_1c_meta_h1')){
						$data['oc_exchange_1c_meta_h1'] = $this->config->get('oc_exchange_1c_meta_h1');
					}else{
						$data['oc_exchange_1c_meta_h1'] = '{name}';
					}
				}
				if (isset($this->request->post['oc_exchange_1c_update_meta_h1'])) {
					$data['oc_exchange_1c_update_meta_h1'] = $this->request->post['oc_exchange_1c_update_meta_h1']==1?'checked':'';
				}
				else {
					if ($this->config->get('oc_exchange_1c_update_meta_h1')){
						$data['oc_exchange_1c_update_meta_h1'] = $this->config->get('oc_exchange_1c_update_meta_h1')==1?'checked':'';
					}else{
						$data['oc_exchange_1c_update_meta_h1'] = '';
					}
				}
				
				if (isset($this->request->post['oc_exchange_1c_meta_description'])) {
					$data['oc_exchange_1c_meta_description'] = $this->request->post['oc_exchange_1c_meta_description'];
				}
				else {
					if ($this->config->get('oc_exchange_1c_meta_description')){
						$data['oc_exchange_1c_meta_description'] = $this->config->get('oc_exchange_1c_meta_description');
					}else{
						$data['oc_exchange_1c_meta_description'] = '{name}';
					}
				}
				if (isset($this->request->post['oc_exchange_1c_update_meta_description'])) {
					$data['oc_exchange_1c_update_meta_description'] = $this->request->post['oc_exchange_1c_update_meta_description']==1?'checked':'';
				}
				else {
					if ($this->config->get('oc_exchange_1c_update_meta_description')){
						$data['oc_exchange_1c_update_meta_description'] = $this->config->get('oc_exchange_1c_update_meta_description')==1?'checked':'';
					}else{
						$data['oc_exchange_1c_update_meta_description'] = '';
					}
				}
				
				if (isset($this->request->post['oc_exchange_1c_meta_keywords'])) {
					$data['oc_exchange_1c_meta_keywords'] = $this->request->post['oc_exchange_1c_meta_keywords'];
				}
				else {
					if ($this->config->get('oc_exchange_1c_meta_keywords')){
						$data['oc_exchange_1c_meta_keywords'] = $this->config->get('oc_exchange_1c_meta_keywords');
					}else{
						$data['oc_exchange_1c_meta_keywords'] = '{name}';
					}
				}
				if (isset($this->request->post['oc_exchange_1c_update_meta_keywords'])) {
					$data['oc_exchange_1c_update_meta_keywords'] = $this->request->post['oc_exchange_1c_update_meta_keywords']==1?'checked':'';
				}
				else {
					if ($this->config->get('oc_exchange_1c_update_meta_keywords')){
						$data['oc_exchange_1c_update_meta_keywords'] = $this->config->get('oc_exchange_1c_update_meta_keywords')==1?'checked':'';
					}else{
						$data['oc_exchange_1c_update_meta_keywords'] = '';
					}
				}
				
				if (isset($this->request->post['oc_exchange_1c_seourl'])) {
					$data['oc_exchange_1c_seourl'] = $this->request->post['oc_exchange_1c_seourl'];
				}
				else {
					if ($this->config->get('oc_exchange_1c_seourl')){
						$data['oc_exchange_1c_seourl'] = $this->config->get('oc_exchange_1c_seourl');
					}else{
						$data['oc_exchange_1c_seourl'] = '{product-id}-{name}';
					}
				}
				if (isset($this->request->post['oc_exchange_1c_update_seourl'])) {
					$data['oc_exchange_1c_update_seourl'] = $this->request->post['oc_exchange_1c_update_seourl']==1?'checked':'';
				}
				else {
					if ($this->config->get('oc_exchange_1c_update_seourl')){
						$data['oc_exchange_1c_update_seourl'] = $this->config->get('oc_exchange_1c_update_seourl')==1?'checked':'';
					}else{
						$data['oc_exchange_1c_update_seourl'] = '';
					}
				}
				
				if (isset($this->request->post['oc_exchange_1c_symbols_deleted_from_tag'])) {
					$data['oc_exchange_1c_words_deleted_from_tag'] = $this->request->post['oc_exchange_1c_words_deleted_from_tag'];
				}
				else {
					if ($this->config->get('oc_exchange_1c_words_deleted_from_tag')){
						$data['oc_exchange_1c_words_deleted_from_tag'] = $this->config->get('oc_exchange_1c_words_deleted_from_tag');
					}else{
						$data['oc_exchange_1c_words_deleted_from_tag'] = 'в,без,до,из,к,на,по,о,от,перед,при,через,с,у,за,над,об,под,про,для';
					}
				}
				if (isset($this->request->post['oc_exchange_1c_words_deleted_from_tag'])) {
					$data['oc_exchange_1c_symbols_deleted_from_tag'] = str_replace('"', '&quot;', $this->request->post['oc_exchange_1c_symbols_deleted_from_tag']);
				}
				else {
					if ($this->config->get('oc_exchange_1c_symbols_deleted_from_tag')){
						$data['oc_exchange_1c_symbols_deleted_from_tag'] = str_replace('"', '&quot;', $this->config->get('oc_exchange_1c_symbols_deleted_from_tag'));
					}else{
						$data['oc_exchange_1c_symbols_deleted_from_tag'] = str_replace('"', '&quot;', '\'|(|)|,|.|:|\\|/|!|?|@|#|$|%|&|*|-|+|=|_|~|№|[|]|{|}|;|<|>|"');
					}
				}
				if (isset($this->request->post['oc_exchange_1c_update_tag'])) {
					$data['oc_exchange_1c_update_tag'] = $this->request->post['oc_exchange_1c_update_tag']==1?'checked':'';
				}
				else {
					if ($this->config->get('oc_exchange_1c_update_tag')){
						$data['oc_exchange_1c_update_tag'] = $this->config->get('oc_exchange_1c_update_tag')==1?'checked':'';
					}else{
						$data['oc_exchange_1c_update_tag'] = '';
					}
				}
				
				// фото
				$selected = 0;
				$oc_exchange_1c_image_load_from_1c = array();
				if (isset($this->request->post['oc_exchange_1c_image_load_from_1c'])) {
					$selected = $this->request->post['oc_exchange_1c_image_load_from_1c'];
				}else {
					if ($this->config->get('oc_exchange_1c_image_load_from_1c')){
						$selected = $this->config->get('oc_exchange_1c_image_load_from_1c');
					}
				}
				$values = array( array(1,$this->language->get('text_yes')), array(0,$this->language->get('text_no')));
				foreach ($values as $i => $value){
					$oc_exchange_1c_image_load_from_1c[$i]['name'] = $value[1];
					$oc_exchange_1c_image_load_from_1c[$i]['value'] = $value[0];
					$oc_exchange_1c_image_load_from_1c[$i]['selected'] = 0;
					if ($value[0] == $selected){
						$oc_exchange_1c_image_load_from_1c[$i]['selected'] = 1;
					}
				}
				$data['oc_exchange_1c_image_load_from_1c'] = $oc_exchange_1c_image_load_from_1c;
				
				$selected = 0;
				$oc_exchange_1c_image_test_main = array();
				if (isset($this->request->post['oc_exchange_1c_image_test_main'])) {
					$selected = $this->request->post['oc_exchange_1c_image_test_main'];
				}else {
					if ($this->config->get('oc_exchange_1c_image_test_main')){
						$selected = $this->config->get('oc_exchange_1c_image_test_main');
					}
				}
				$values = array( array(1,$this->language->get('text_yes')), array(0,$this->language->get('text_no')));
				foreach ($values as $i => $value){
					$oc_exchange_1c_image_test_main[$i]['name'] = $value[1];
					$oc_exchange_1c_image_test_main[$i]['value'] = $value[0];
					$oc_exchange_1c_image_test_main[$i]['selected'] = 0;
					if ($value[0] == $selected){
						$oc_exchange_1c_image_test_main[$i]['selected'] = 1;
					}
				}
				$data['oc_exchange_1c_image_test_main'] = $oc_exchange_1c_image_test_main;
				
				if (isset($this->request->post['oc_exchange_1c_image_ext'])) {
					$data['oc_exchange_1c_image_ext'] = $this->request->post['oc_exchange_1c_image_ext'];
				}
				else {
					if ($this->config->get('oc_exchange_1c_image_ext')){
						$data['oc_exchange_1c_image_ext'] = $this->config->get('oc_exchange_1c_image_ext');
					}else{
						$data['oc_exchange_1c_image_ext'] = 'jpg,png,jpeg';
					}
				}
				if (isset($this->request->post['oc_exchange_1c_image_output'])) {
					$data['oc_exchange_1c_image_output'] = $this->request->post['oc_exchange_1c_image_output'];
				}
				else {
					if ($this->config->get('oc_exchange_1c_image_output')){
						$data['oc_exchange_1c_image_output'] = $this->config->get('oc_exchange_1c_image_output');
					}else{
						$data['oc_exchange_1c_image_output'] = 'jpg';
					}
				}
				if (isset($this->request->post['oc_exchange_1c_image_width'])) {
					$data['oc_exchange_1c_image_width'] = $this->request->post['oc_exchange_1c_image_width'];
				}
				else {
					if ($this->config->get('oc_exchange_1c_image_width')){
						$data['oc_exchange_1c_image_width'] = $this->config->get('oc_exchange_1c_image_width');
					}else{
						$data['oc_exchange_1c_image_width'] = '500';
					}
				}
				if (isset($this->request->post['oc_exchange_1c_image_height'])) {
					$data['oc_exchange_1c_image_height'] = $this->request->post['oc_exchange_1c_image_height'];
				}
				else {
					if ($this->config->get('oc_exchange_1c_image_height')){
						$data['oc_exchange_1c_image_height'] = $this->config->get('oc_exchange_1c_image_height');
					}else{
						$data['oc_exchange_1c_image_height'] = '500';
					}
				}
				if (isset($this->request->post['oc_exchange_1c_image_quality'])) {
					$data['oc_exchange_1c_image_quality'] = $this->request->post['oc_exchange_1c_image_quality'];
				}
				else {
					if ($this->config->get('oc_exchange_1c_image_quality')){
						$data['oc_exchange_1c_image_quality'] = $this->config->get('oc_exchange_1c_image_quality');
					}else{
						$data['oc_exchange_1c_image_quality'] = '90';
					}
				}
				if (isset($this->request->post['oc_exchange_1c_image_dir'])) {
					$data['oc_exchange_1c_image_dir'] = $this->request->post['oc_exchange_1c_image_dir'];
				}
				else {
					if ($this->config->get('oc_exchange_1c_image_dir')){
						$data['oc_exchange_1c_image_dir'] = $this->config->get('oc_exchange_1c_image_dir');
					}else{
						$data['oc_exchange_1c_image_dir'] = 'products';
					}
				}
				
				// специальные настройки
				$selected = 0;
				$oc_exchange_1c_hide_missing_products = array();
				if (isset($this->request->post['oc_exchange_1c_hide_missing_products'])) {
					$selected = $this->request->post['oc_exchange_1c_hide_missing_products'];
				}else {
					if ($this->config->get('oc_exchange_1c_hide_missing_products')){
						$selected = $this->config->get('oc_exchange_1c_hide_missing_products');
					}
				}
				$values = array( array(1,$this->language->get('text_yes')), array(0,$this->language->get('text_no')));
				foreach ($values as $i => $value){
					$oc_exchange_1c_hide_missing_products[$i]['name'] = $value[1];
					$oc_exchange_1c_hide_missing_products[$i]['value'] = $value[0];
					$oc_exchange_1c_hide_missing_products[$i]['selected'] = 0;
					if ($value[0] == $selected){
						$oc_exchange_1c_hide_missing_products[$i]['selected'] = 1;
					}
				}
				$data['oc_exchange_1c_hide_missing_products'] = $oc_exchange_1c_hide_missing_products;
				
				$selected = 0;
				$oc_exchange_1c_hide_products_with_zero_quantity = array();
				if (isset($this->request->post['oc_exchange_1c_hide_products_with_zero_quantity'])) {
					$selected = $this->request->post['oc_exchange_1c_hide_products_with_zero_quantity'];
				}else {
					if ($this->config->get('oc_exchange_1c_hide_products_with_zero_quantity')){
						$selected = $this->config->get('oc_exchange_1c_hide_products_with_zero_quantity');
					}
				}
				$values = array( array(1,$this->language->get('text_yes')), array(0,$this->language->get('text_no')));
				foreach ($values as $i => $value){
					$oc_exchange_1c_hide_products_with_zero_quantity[$i]['name'] = $value[1];
					$oc_exchange_1c_hide_products_with_zero_quantity[$i]['value'] = $value[0];
					$oc_exchange_1c_hide_products_with_zero_quantity[$i]['selected'] = 0;
					if ($value[0] == $selected){
						$oc_exchange_1c_hide_products_with_zero_quantity[$i]['selected'] = 1;
					}
				}
				$data['oc_exchange_1c_hide_products_with_zero_quantity'] = $oc_exchange_1c_hide_products_with_zero_quantity;
				
				$selected = 0;
				$oc_exchange_1c_show_not_changed = array();
				if (isset($this->request->post['oc_exchange_1c_show_not_changed'])) {
					$selected = $this->request->post['oc_exchange_1c_show_not_changed'];
				}else {
					if ($this->config->get('oc_exchange_1c_show_not_changed')){
						$selected = $this->config->get('oc_exchange_1c_show_not_changed');
					}
				}
				$values = array( array(1,$this->language->get('text_yes')), array(0,$this->language->get('text_no')));
				foreach ($values as $i => $value){
					$oc_exchange_1c_show_not_changed[$i]['name'] = $value[1];
					$oc_exchange_1c_show_not_changed[$i]['value'] = $value[0];
					$oc_exchange_1c_show_not_changed[$i]['selected'] = 0;
					if ($value[0] == $selected){
						$oc_exchange_1c_show_not_changed[$i]['selected'] = 1;
					}
				}
				$data['oc_exchange_1c_show_not_changed'] = $oc_exchange_1c_show_not_changed;
				
				// папки с кэшем для очистки
				if (isset($this->request->post['oc_exchange_1c_cache'])) {
					$data['oc_exchange_1c_cache'] = $this->request->post['oc_exchange_1c_cache'];
				}
				else {
					if ($this->config->get('oc_exchange_1c_cache')){
						$data['oc_exchange_1c_cache'] = $this->config->get('oc_exchange_1c_cache');
					}else{
						$data['oc_exchange_1c_cache'] = '';
					}
				}
				
				// заказы
				if (isset($this->request->post['oc_exchange_1c_order_status_to_exchange'])) {
					$data['oc_exchange_1c_order_status_to_exchange'] = $this->request->post['oc_exchange_1c_order_status_to_exchange'];
				} else {
					$data['oc_exchange_1c_order_status_to_exchange'] = $this->config->get('oc_exchange_1c_order_status_to_exchange');
				}
		
				if (isset($this->request->post['oc_exchange_1c_order_status'])) {
					$data['oc_exchange_1c_order_status'] = $this->request->post['oc_exchange_1c_order_status'];
				}
				else {
					$data['oc_exchange_1c_order_status'] = $this->config->get('oc_exchange_1c_order_status');
				}
				
				$selected = 0;
				$oc_exchange_1c_order_charset = array();
				if (isset($this->request->post['oc_exchange_1c_order_charset'])) {
					$selected = $this->request->post['oc_exchange_1c_order_charset'];
				}else {
					if ($this->config->get('oc_exchange_1c_order_charset')){
						$selected = $this->config->get('oc_exchange_1c_order_charset');
					}
				}
				$values = array( array(1,'windows-1251'), array(0,'UTF-8'));
				foreach ($values as $i => $value){
					$oc_exchange_1c_order_charset[$i]['name'] = $value[1];
					$oc_exchange_1c_order_charset[$i]['value'] = $value[0];
					$oc_exchange_1c_order_charset[$i]['selected'] = 0;
					if ($value[0] == $selected){
						$oc_exchange_1c_order_charset[$i]['selected'] = 1;
					}
				}
				$data['oc_exchange_1c_order_charset'] = $oc_exchange_1c_order_charset;
				
				if (isset($this->request->post['oc_exchange_1c_order_currency'])) {
					$data['oc_exchange_1c_order_currency'] = $this->request->post['oc_exchange_1c_order_currency'];
				}
				else {
					if ($this->config->get('oc_exchange_1c_order_currency')){
						$data['oc_exchange_1c_order_currency'] = $this->config->get('oc_exchange_1c_order_currency');
					}else{
						$data['oc_exchange_1c_order_currency'] = '';
					}
				}
		
				if (isset($this->request->post['oc_exchange_1c_order_scheme_version'])) {
					$data['oc_exchange_1c_order_scheme_version'] = $this->request->post['oc_exchange_1c_order_scheme_version'];
				}
				else {
					if ($this->config->get('oc_exchange_1c_order_scheme_version')){
						$data['oc_exchange_1c_order_scheme_version'] = $this->config->get('oc_exchange_1c_order_scheme_version');
					}else{
						$data['oc_exchange_1c_order_scheme_version'] = '2.03';
					}
				}
				
				$selected = 0;
				$oc_exchange_1c_order_confirm = array();
				if (isset($this->request->post['oc_exchange_1c_order_confirm'])) {
					$selected = $this->request->post['oc_exchange_1c_order_confirm'];
				}else {
					if ($this->config->get('oc_exchange_1c_order_confirm')){
						$selected = $this->config->get('oc_exchange_1c_order_confirm');
					}
				}
				$values = array( array(1,$this->language->get('text_yes')), array(0,$this->language->get('text_no')));
				foreach ($values as $i => $value){
					$oc_exchange_1c_order_confirm[$i]['name'] = $value[1];
					$oc_exchange_1c_order_confirm[$i]['value'] = $value[0];
					$oc_exchange_1c_order_confirm[$i]['selected'] = 0;
					if ($value[0] == $selected){
						$oc_exchange_1c_order_confirm[$i]['selected'] = 1;
					}
				}
				$data['oc_exchange_1c_order_confirm'] = $oc_exchange_1c_order_confirm;
				

				$this->load->model('localisation/order_status');
		
				$order_statuses = $this->model_localisation_order_status->getOrderStatuses();
		
				foreach ($order_statuses as $order_status) {
					$data['order_statuses'][] = array(
						'order_status_id' => $order_status['order_status_id'],
						'name'			  => $order_status['name']
					);
				}
			
			
		}

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view("module/oc_exchange_1c_$version.tpl", $data));
	}

	private function validate($version) {

		if (!$this->user->hasPermission('modify', "module/oc_exchange_1c_$version")) {
			$this->error['warning'] = $this->language->get('oc_exchange_1c_error_permission');
		}else{
	
			// отметка ключа
			if (!isset($this->request->post['oc_exchange_1c_key'])){
				$this->error['key'] = $this->language->get('oc_exchange_1c_error_key');
			}else{
				
				// проверка категорий сайта в параметре Соответствие категорий 1С категориям сайта
				if ($this->request->post['oc_exchange_1c_categories_corr'] != ''){
					$this->load->model('catalog/category');
					$site_categories = $this->model_catalog_category->getCategories();
//	echo '<pre>'; print_r ($site_categories);	die;

					// &nbsp;&nbsp;&gt;&nbsp;&nbsp;
					
					$param_array = explode("\n", $this->request->post['oc_exchange_1c_categories_corr']);
					$i=0;
					foreach ($param_array as $string){
						if (strpos($string, '=') !== false){
							list($in_1c, $in_base) = explode('=', $string);
//echo '<br/>'.$in_1c.'='.$in_base;
							$in_base1 = str_replace('&gt;', '&nbsp;&nbsp;&gt;&nbsp;&nbsp;', trim($in_base));
							$found = false;
							foreach ($site_categories as $site_category){
								if ($site_category['name'] == $in_base1){
									$found = true;
									break;
								}
							}
							if (!$found){
								$this->error['in_base'.$i++] = $this->language->get('oc_exchange_1c_error_in_base').' ' .$string;
							}
						}
					}
				}
//die;				
				// допустимые значения полей
				if (strpos($this->request->post['oc_exchange_1c_attributes'], '=') !== false){
					
					$attr_to_fields = array('upc', 'ean', 'jan', 'isbn', 'mpn', 'manufacturer', 'weight', 'length', 'width', 'height' );
					
					$string = $this->request->post['oc_exchange_1c_attributes'];
	
					$attr_array = explode("\n", $string);
					
					foreach ($attr_array as $attr){
						
						if (strpos($attr, '=') !== false){
							
							list($attr, $pole) = explode('=', $attr);
							if (in_array(trim($pole), $attr_to_fields)){
								
							}else{
								$this->error[$attr] = $this->language->get('oc_exchange_1c_error_pole').$pole;
							}
			
						}
						
					}
				}
				
				// цена - обязательно
				if ($this->request->post['oc_exchange_1c_price'] == ''){
					$this->error['price'] = $this->language->get('oc_exchange_1c_error_price');
				}
				
				// цена - обязательно
				if ($this->request->post['oc_exchange_1c_order_currency'] == ''){
					$this->error['order_currency'] = $this->language->get('oc_exchange_1c_error_order_currency');
				}
				
				// допустимые расширения входных файлов изображений
				$exts = array('jpg', 'jpeg', 'png', 'gif');
				$image_exts = explode(',' ,trim($this->request->post['oc_exchange_1c_image_ext']));
				$found = false;
				foreach ($image_exts as $ext){
					if (in_array($ext, $exts)){
						$found = true;
						break;
					}
				}
				if (!$found){
					$this->error['exts'] = $this->language->get('oc_exchange_1c_error_exts').' '.implode(',', $exts);
				}
				
				// допустимые расширения выходных файлов изображений
				$exts = array('jpg', 'png');
				$output_ext = trim($this->request->post['oc_exchange_1c_image_output']);
				$found = false;
				if (!in_array($output_ext, $exts)){
					$this->error['output'] = $this->language->get('oc_exchange_1c_error_output').' '.implode(',', $exts);
				}
				
				// допустимое качество изображения в зависимости от типа
				$value = (int)trim($this->request->post['oc_exchange_1c_image_quality']);
				switch ($output_ext){
					case 'jpg':
						if (50 <= $value AND $value <= 100){
							// ок
						}else{
							$this->error['quality'] = $this->language->get('oc_exchange_1c_error_quality').' 50 - 100';
						}
						break;
					case 'png':
						if (0 <= $value AND $value <= 9){
							// ок
						}else{
							$this->error['quality'] = $this->language->get('oc_exchange_1c_error_quality').' 0 - 9';
						}
						break;
				}
				
				// папка для фото - проверка на запись
				if (!is_dir('../image/'.trim($this->request->post['oc_exchange_1c_image_dir']))){
					$mk = mkdir('../image/'.trim($this->request->post['oc_exchange_1c_image_dir']));
					if ($mk === false){
						$this->error['create_output'] = $this->language->get('oc_exchange_1c_error_dir_create');
					}else{
						chmod('../image/'.trim($this->request->post['oc_exchange_1c_image_dir']), 0775);
					}
				}
				if (is_dir('../image/'.trim($this->request->post['oc_exchange_1c_image_dir']))){
					$dir = '../image/'.trim($this->request->post['oc_exchange_1c_image_dir']);
					$handle = fopen($dir.'/test_img.tmp', "w");
					if ($handle === false){
						$this->error['output'] = $this->language->get('oc_exchange_1c_error_file_create');
					}else{
						$bytes = fwrite($handle, "writing to tempfile");
						if ($bytes == strlen("writing to tempfile")){
							
						}else{
							$this->error['output'] = $this->language->get('oc_exchange_1c_error_file_write');
						}
						fclose($handle);
						unlink($dir.'/test_img.tmp');
					}
					
				}else{
					$this->error['dir'] = $this->language->get('oc_exchange_1c_error_dir');
				}
				
				// не совпадение статусов заказов
				if ($this->request->post['oc_exchange_1c_order_status_to_exchange'] == $this->request->post['oc_exchange_1c_order_status']){
					$this->error['order'] = $this->language->get('oc_exchange_1c_error_order');
				}
			}

		}

		if (!$this->error){
			return true;
		}else {
			return false;
		}
	}

	public function install() {}

	public function uninstall() {
		// удаление всех настроек
		$this->model_setting_setting->deleteSetting('oc_exchange_1c');
	}
	
	private function curl_get_contents($url, array $get = array(), array $options = array())
{    
	
    $defaults = array(
       CURLOPT_URL => $url. (strpos($url, '?') === FALSE ? '?' : ''). http_build_query($get),
       CURLOPT_HEADER => 0,
       CURLOPT_RETURNTRANSFER => TRUE,
       CURLOPT_TIMEOUT => 60,
       CURLOPT_SSL_VERIFYPEER => false
    );
   
    $ch = curl_init();
    curl_setopt_array($ch, ($options + $defaults));
	curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 6.1; en-US; rv:1.9.1.2) Gecko/20090729 Firefox/3.5.2 GTB5');
    if(!$result = curl_exec($ch)) {
       	trigger_error(curl_error($ch));
		$result = 'error: '.curl_error($ch);
    }else{
    	//echo 'OK';
    }
    curl_close($ch);
   
    return $result;
}

	private function getCategoriesByParentId($parent_id = 0) {
		$query = $this->db->query("SELECT *, (SELECT COUNT(parent_id) FROM " . DB_PREFIX . "category WHERE parent_id = c.category_id) AS children FROM " . DB_PREFIX . "category c LEFT JOIN " . DB_PREFIX . "category_description cd ON (c.category_id = cd.category_id) WHERE c.parent_id = '" . (int)$parent_id . "' AND cd.language_id = '" . (int)$this->config->get('config_language_id') . "' ORDER BY c.sort_order, cd.name");

		return $query->rows;
	}

}


